/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;
import reliquary.items.ItemBase;
import reliquary.util.InventoryHelper;
import reliquary.util.NBTHelper;
import reliquary.util.RandHelper;
import reliquary.util.RegistryHelper;

public abstract class ToggleableItem
extends ItemBase {
    protected static final String QUANTITY_TAG = "Quantity";
    protected static final String ITEM_NAME_TAG = "Name";
    private static final String ENABLED_TAG = "enabled";
    private static final String COOLDOWN_TAG = "coolDown";
    private static final String ITEMS_TAG = "Items";

    protected ToggleableItem(Item.Properties properties, Supplier<Boolean> isDisabled) {
        super(properties, isDisabled);
    }

    protected ToggleableItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return this.isEnabled(stack);
    }

    protected void setCooldown(ItemStack stack, Level world, int cooldown) {
        NBTHelper.putLong(COOLDOWN_TAG, stack, world.m_46467_() + (long)cooldown);
    }

    protected boolean isInCooldown(ItemStack stack, Level world) {
        return NBTHelper.getLong(COOLDOWN_TAG, stack) > world.m_46467_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && player.m_6144_()) {
            this.toggleEnabled(stack);
            player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.7f + 1.2f));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_() || oldStack.m_41790_() != newStack.m_41790_();
    }

    public boolean isEnabled(ItemStack stack) {
        return NBTHelper.getBoolean(ENABLED_TAG, stack);
    }

    void toggleEnabled(ItemStack stack) {
        NBTHelper.putBoolean(ENABLED_TAG, stack, !NBTHelper.getBoolean(ENABLED_TAG, stack));
    }

    public static boolean hasEnabledTag(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(ENABLED_TAG);
    }

    protected void consumeAndCharge(Player player, int freeCapacity, int chargePerItem, Item item, int maxCount, IntConsumer addCharge) {
        this.consumeAndCharge(player, freeCapacity, chargePerItem, (ItemStack ist) -> ist.m_41720_() == item, maxCount, addCharge);
    }

    protected void consumeAndCharge(Player player, int freeCapacity, int chargePerItem, Predicate<ItemStack> itemMatches, int maxCount, IntConsumer addCharge) {
        int maximumToConsume = Math.min(freeCapacity / chargePerItem, maxCount);
        if (maximumToConsume == 0) {
            return;
        }
        int chargeToAdd = InventoryHelper.consumeItemStack(itemMatches, player, maximumToConsume).m_41613_() * chargePerItem;
        if (chargeToAdd > 0) {
            addCharge.accept(chargeToAdd);
        }
    }

    protected void addItemToInternalStorage(ItemStack stack, Item item, int chargeToAdd) {
        this.addItemToInternalStorage(stack, RegistryHelper.getItemRegistryName(item), chargeToAdd);
    }

    protected void addItemToInternalStorage(ItemStack stack, String itemRegistryName, int chargeToAdd) {
        AtomicBoolean found = new AtomicBoolean(false);
        this.updateItems(stack, tag -> {
            String itemName = tag.m_128461_(ITEM_NAME_TAG);
            if (itemName.equals(itemRegistryName)) {
                int quantity = tag.m_128451_(QUANTITY_TAG);
                tag.m_128405_(QUANTITY_TAG, quantity + chargeToAdd);
                found.set(true);
            }
        }, found::get, list -> {
            if (!found.get()) {
                CompoundTag newTagData = new CompoundTag();
                newTagData.m_128359_(ITEM_NAME_TAG, itemRegistryName);
                newTagData.m_128405_(QUANTITY_TAG, chargeToAdd);
                list.add((Object)newTagData);
            }
        });
    }

    private void updateItems(ItemStack stack, Consumer<CompoundTag> actOnItemTag, BooleanSupplier shouldExit, Consumer<ListTag> actOnListAfter) {
        CompoundTag tag = NBTHelper.getTag(stack);
        this.iterateItems(tag, actOnItemTag, shouldExit, itemList -> {
            tag.m_128365_(ITEMS_TAG, (Tag)itemList);
            actOnListAfter.accept((ListTag)itemList);
        });
        stack.m_41751_(tag);
    }

    protected void iterateItems(ItemStack stack, Consumer<CompoundTag> actOnItemTag, BooleanSupplier shouldExit) {
        this.iterateItems(NBTHelper.getTag(stack), actOnItemTag, shouldExit, list -> {});
    }

    private void iterateItems(CompoundTag tagCompound, Consumer<CompoundTag> actOnItemTag, BooleanSupplier shouldExit, Consumer<ListTag> actOnListAfter) {
        ListTag tagList = tagCompound.m_128437_(ITEMS_TAG, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            actOnItemTag.accept(tagList.m_128728_(i));
            if (shouldExit.getAsBoolean()) break;
        }
        actOnListAfter.accept(tagList);
    }

    public boolean removeItemFromInternalStorage(ItemStack stack, ForgeRegistryEntry<?> registryEntry, int quantityToRemove, boolean simulate, Player player) {
        if (player.m_7500_()) {
            return true;
        }
        AtomicBoolean updated = new AtomicBoolean(false);
        this.updateItems(stack, tag -> {
            String itemName = tag.m_128461_(ITEM_NAME_TAG);
            if (itemName.equals(RegistryHelper.getRegistryName(registryEntry).toString())) {
                int originalQuantity = tag.m_128451_(QUANTITY_TAG);
                if (originalQuantity - quantityToRemove < 0) {
                    updated.set(false);
                    return;
                }
                if (!simulate) {
                    tag.m_128405_(QUANTITY_TAG, originalQuantity - quantityToRemove);
                }
                updated.set(true);
            }
        }, updated::get, list -> {});
        return updated.get();
    }

    public void removeItemTagInInternalStorage(ItemStack stack, Item item) {
        String registryName = RegistryHelper.getItemRegistryName(item);
        ListTag tagList = NBTHelper.getTag(stack).m_128437_(ITEMS_TAG, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemCountTag = tagList.m_128728_(i);
            if (!itemCountTag.m_128461_(ITEM_NAME_TAG).equals(registryName)) continue;
            tagList.remove(i);
            return;
        }
    }

    public int getInternalStorageItemCount(ItemStack stack, Item item) {
        return this.getInternalStorageItemCount(stack, RegistryHelper.getItemRegistryName(item));
    }

    public int getInternalStorageItemCount(ItemStack stack, String itemRegistryName) {
        AtomicInteger ret = new AtomicInteger(-1);
        this.iterateItems(stack, tag -> {
            if (tag.m_128461_(ITEM_NAME_TAG).equals(itemRegistryName)) {
                ret.set(tag.m_128451_(QUANTITY_TAG));
            }
        }, () -> ret.get() >= 0);
        return Math.max(ret.get(), 0);
    }

    protected boolean hasSpaceForItem(ItemStack stack, Item item, int quantityLimit) {
        return this.getInternalStorageItemCount(stack, item) < quantityLimit;
    }
}

